function [ logout, zout ] = image2log( image )

l = nan( 1, size( image, 1) );

for z = 1 : size( image, 1),
    row = image( z, :);
    if any( row == 0 ),
        l(z) = median( find( row == 0 ) );
    end
end

step = 10;

zoutsize = floor( size( image, 1) /step )-2;
zout = floor( step / 2) : step : floor( step / 2) + step*zoutsize ;
logout = nan( 1, zoutsize +1 );

for outidx = 1 : zoutsize+1,        
    logout( outidx ) = medianf( l( zout( outidx ) : zout( outidx )+step) );
end

if any( isnan( logout ) ),
       
    idx = 1;
    while isnan( logout( idx ) )
        idx = idx + 1;
    end
    logout( 1 : idx-1 ) = logout(idx);
           
    idx = length( logout );
    while isnan( logout( idx ) )
        idx = idx - 1;
    end
    logout( idx+1 : end ) = logout(idx);
    
    lognans = find( isnan(logout));
    
    
    for loop = 1: length( lognans ),
        
       validbelow = lognans( loop );
       while isnan( logout( validbelow ) )
           validbelow = validbelow + 1;
       end 
       
       validabove = lognans( loop );
       while isnan( logout( validabove ) )
           validabove = validabove - 1;
       end
       
       d = ( zout( lognans( loop ) ) - zout( validabove ) ) / ( zout( validbelow) - zout( validabove) );
       logout( lognans( loop ) ) = logout( validabove)* d + logout( validbelow) *(1-d);
    end
       
end